/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Kiwi;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.loader.KBlockDefinition;
import snownee.kiwi.customization.block.loader.KBlockTemplate;
import snownee.kiwi.customization.duck.KBlockProperties;
import snownee.kiwi.customization.item.MultipleBlockItem;
import snownee.kiwi.customization.placement.ParsedProtoTag;
import snownee.kiwi.customization.placement.PlaceSlot;
import snownee.kiwi.customization.placement.PlaceTarget;
import snownee.kiwi.customization.placement.SlotLink;
import snownee.kiwi.customization.placement.StatePropertiesPredicate;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.BlockPredicateHelper;
import snownee.kiwi.util.KHolder;
import snownee.kiwi.util.Util;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record PlaceChoices(List<PlaceTarget> target, Optional<String> transformWith, List<Flow> flow, List<Alter> alter, List<Limit> limit, List<Interests> interests, boolean skippable) {
    public static final BiMap<String, BlockFaceType> BLOCK_FACE_TYPES = HashBiMap.create();
    public static final Codec<PlaceChoices> CODEC;

    public static void setTo(class_2248 block, @Nullable KHolder<PlaceChoices> holder) {
        KBlockSettings settings = KBlockSettings.of(block);
        if (settings == null && holder != null) {
            settings = KBlockSettings.empty();
            ((KBlockProperties)block.field_23155).kiwi$setSettings(settings);
        }
        if (settings != null) {
            settings.placeChoices = holder == null ? null : holder.value();
        }
    }

    public int test(class_2680 baseState, class_2680 targetState) {
        for (Limit limit : this.limit) {
            if (limit.test(baseState, targetState)) continue;
            return Integer.MIN_VALUE;
        }
        int interest = 0;
        for (Interests provider : this.interests) {
            if (!provider.when().smartTest(baseState, targetState)) continue;
            interest += provider.bonus;
        }
        return interest;
    }

    public class_2680 getStateForPlacement(class_1937 level, class_2338 pos, class_2680 original) {
        if (this.flow.isEmpty()) {
            return original;
        }
        MutableObject rotation = new MutableObject((Object)class_2470.field_11467);
        String transformWith = this.transformWith.orElse("none");
        if (!transformWith.equals("none")) {
            class_2769<?> property = KBlockUtils.getProperty(original, transformWith);
            if (!(property instanceof class_2753)) {
                throw new IllegalArgumentException("Invalid transform_with property: " + transformWith);
            }
            class_2753 directionProperty = (class_2753)property;
            class_2350 direction = (class_2350)original.method_11654((class_2769)directionProperty);
            for (class_2470 r : class_2470.values()) {
                if (r.method_10503(class_2350.field_11043) != direction) continue;
                rotation.setValue((Object)r);
                break;
            }
        }
        class_2680 blockState = original;
        class_2338.class_2339 mutable = pos.method_25503();
        block3: for (Flow f : this.flow) {
            for (Map.Entry<class_2350, Limit> entry : f.when.entrySet()) {
                class_2350 direction = ((class_2470)rotation.getValue()).method_10503(entry.getKey());
                try {
                    if (entry.getValue().testFace(level.method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)), direction.method_10153())) continue;
                }
                catch (Exception e) {}
                continue block3;
            }
            blockState = f.action.apply(level, (class_2338)mutable, blockState);
            if (!f.end) continue;
            break;
        }
        return blockState;
    }

    static {
        BLOCK_FACE_TYPES.put((Object)"any", (Object)BlockFaceType.ANY);
        BLOCK_FACE_TYPES.put((Object)"horizontal", (Object)BlockFaceType.HORIZONTAL);
        BLOCK_FACE_TYPES.put((Object)"vertical", (Object)BlockFaceType.VERTICAL);
        BLOCK_FACE_TYPES.put((Object)"clicked_face", (context, direction) -> context.method_8038() == direction.method_10153());
        for (class_2350 direction2 : Util.DIRECTIONS) {
            BLOCK_FACE_TYPES.put((Object)direction2.method_15434(), (context, dir) -> dir == direction2);
        }
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.compactList(PlaceTarget.CODEC).fieldOf("target").forGetter(PlaceChoices::target), (App)CustomizationCodecs.strictOptionalField(Codec.STRING, "transform_with").forGetter(PlaceChoices::transformWith), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.compactList(Flow.CODEC), "flow", List.of()).forGetter(PlaceChoices::flow), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.compactList(Alter.CODEC), "alter", List.of()).forGetter(PlaceChoices::alter), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.compactList(Limit.CODEC), "limit", List.of()).forGetter(PlaceChoices::limit), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.compactList(Interests.CODEC), "interests", List.of()).forGetter(PlaceChoices::interests), (App)Codec.BOOL.optionalFieldOf("skippable", (Object)true).forGetter(PlaceChoices::skippable)).apply((Applicative)instance, PlaceChoices::new));
    }

    public record Limit(String type, List<ParsedProtoTag> tags) {
        public static final Codec<Limit> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(Limit::type), (App)CustomizationCodecs.compactList(ParsedProtoTag.CODEC).fieldOf("tags").forGetter(Limit::tags)).apply((Applicative)instance, Limit::new));

        public boolean test(class_2680 baseState, class_2680 targetState) {
            for (ParsedProtoTag tag : this.tags) {
                boolean pass;
                ParsedProtoTag resolvedTag = tag.resolve(baseState, class_2470.field_11467);
                if (pass = (switch (this.type) {
                    case "has_tags" -> {
                        for (class_2350 direction : Util.DIRECTIONS) {
                            Collection<PlaceSlot> slots = PlaceSlot.find(targetState, direction);
                            for (PlaceSlot slot : slots) {
                                if (!slot.hasTag(resolvedTag)) continue;
                                yield true;
                            }
                        }
                        yield false;
                    }
                    default -> false;
                })) continue;
                return false;
            }
            return true;
        }

        public boolean testFace(class_2680 blockState, class_2350 direction) {
            Collection<PlaceSlot> slots = PlaceSlot.find(blockState, direction);
            for (ParsedProtoTag tag : this.tags) {
                boolean pass;
                ParsedProtoTag resolvedTag = tag.resolve(blockState, class_2470.field_11467);
                if (pass = (switch (this.type) {
                    case "has_tags" -> {
                        for (PlaceSlot slot : slots) {
                            if (!slot.hasTag(resolvedTag)) continue;
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                })) continue;
                return false;
            }
            return true;
        }
    }

    public record Interests(StatePropertiesPredicate when, int bonus) {
        public static final Codec<Interests> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StatePropertiesPredicate.CODEC.fieldOf("when").forGetter(Interests::when), (App)Codec.INT.fieldOf("bonus").forGetter(Interests::bonus)).apply((Applicative)instance, Interests::new));
    }

    public record Flow(Map<class_2350, Limit> when, SlotLink.ResultAction action, boolean end) {
        public static final Codec<Flow> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(CustomizationCodecs.DIRECTION, Limit.CODEC).fieldOf("when").forGetter(Flow::when), (App)SlotLink.ResultAction.MAP_CODEC.forGetter(Flow::action), (App)Codec.BOOL.optionalFieldOf("end", (Object)false).forGetter(Flow::end)).apply((Applicative)instance, Flow::new));
    }

    public record Alter(List<AlterCondition> when, String use) {
        public static final Codec<Alter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_36973(CustomizationCodecs.compactList(AlterCondition.CODEC)).fieldOf("when").forGetter(Alter::when), (App)Codec.STRING.fieldOf("use").forGetter(Alter::use)).apply((Applicative)instance, Alter::new));

        @Nullable
        public class_2680 alter(class_1747 blockItem, class_1750 context) {
            if (!(blockItem instanceof MultipleBlockItem)) {
                return null;
            }
            MultipleBlockItem multipleBlockItem = (MultipleBlockItem)blockItem;
            for (AlterCondition condition : this.when) {
                if (!condition.test(context)) continue;
                class_2248 block = multipleBlockItem.getBlock(this.use);
                Preconditions.checkNotNull((Object)block, (String)"Block %s not found in %s", (Object)this.use, (Object)((Object)multipleBlockItem));
                Preconditions.checkState((block != blockItem.method_7711() ? 1 : 0) != 0, (String)"Block %s is the same as the original block, dead loop detected", (Object)block);
                class_2680 blockState = block.method_9605(context);
                if (blockState == null) {
                    return null;
                }
                KBlockSettings settings = KBlockSettings.of(block);
                if (settings != null) {
                    blockState = settings.getStateForPlacement(blockState, context);
                }
                return blockState;
            }
            return null;
        }
    }

    public static interface BlockFaceType
    extends BiPredicate<class_1838, class_2350> {
        public static final BlockFaceType ANY = (context, direction) -> true;
        public static final BlockFaceType HORIZONTAL = (context, direction) -> direction.method_10166().method_10179();
        public static final BlockFaceType VERTICAL = (context, direction) -> direction.method_10166().method_10178();
    }

    public record AlterCondition(String target, BlockFaceType faces, class_4550 block, List<ParsedProtoTag> tags) {
        public static final Codec<AlterCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CustomizationCodecs.strictOptionalField(Codec.STRING, "target", "neighbor").forGetter(AlterCondition::target), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.simpleByNameCodec(BLOCK_FACE_TYPES), "faces", BlockFaceType.ANY).forGetter(AlterCondition::faces), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.BLOCK_PREDICATE, "block", class_4550.field_20692).forGetter(AlterCondition::block), (App)CustomizationCodecs.strictOptionalField(CustomizationCodecs.compactList(ParsedProtoTag.CODEC), "tags", List.of()).forGetter(AlterCondition::tags)).apply((Applicative)instance, AlterCondition::new));

        public boolean test(class_1750 context) {
            List<class_2350> directions = switch (this.target) {
                case "clicked_face" -> List.of(context.method_8038().method_10153());
                case "neighbor" -> Util.DIRECTIONS;
                default -> throw new IllegalStateException("Unexpected value: " + this.target);
            };
            class_2338 pos = context.method_8037();
            class_2338.class_2339 mutable = pos.method_25503();
            block8: for (class_2350 direction : directions) {
                class_2680 neighbor;
                if (!this.faces.test(context, direction) || !BlockPredicateHelper.fastMatch(this.block, neighbor = context.method_8045().method_8320((class_2338)mutable.method_25505((class_2382)pos, direction)))) continue;
                for (ParsedProtoTag tag : this.tags) {
                    ParsedProtoTag resolvedTag = tag.resolve(neighbor, class_2470.field_11467);
                    if (!PlaceSlot.find(neighbor, direction.method_10153()).stream().noneMatch(slot -> slot.hasTag(resolvedTag))) continue;
                    continue block8;
                }
                return true;
            }
            return false;
        }
    }

    public record Preparation(Map<class_2960, PlaceChoices> choices, Map<KBlockTemplate, KHolder<PlaceChoices>> byTemplate, Map<class_2960, KHolder<PlaceChoices>> byBlock) {
        public static Preparation of(Supplier<Map<class_2960, PlaceChoices>> choicesSupplier, Map<class_2960, KBlockTemplate> templates) {
            Map<class_2960, PlaceChoices> choices = Platform.isDataGen() ? Map.of() : choicesSupplier.get();
            HashMap byTemplate = Maps.newHashMap();
            HashMap byBlock = Maps.newHashMap();
            for (Map.Entry entry : choices.entrySet()) {
                KHolder<PlaceChoices> holder = new KHolder<PlaceChoices>((class_2960)entry.getKey(), (PlaceChoices)entry.getValue());
                for (PlaceTarget target : holder.value().target) {
                    switch (target.type()) {
                        case TEMPLATE: {
                            KBlockTemplate template = templates.get(target.id());
                            if (template == null) {
                                Kiwi.LOGGER.error("Template {} not found for place choices {}", (Object)target.id(), holder);
                                break;
                            }
                            KHolder<PlaceChoices> oldChoices = byTemplate.put(template, holder);
                            if (oldChoices == null) break;
                            Kiwi.LOGGER.error("Duplicate place choices for template {}: {} and {}", new Object[]{template, oldChoices, holder});
                            break;
                        }
                        case BLOCK: {
                            KHolder<PlaceChoices> oldChoices = byBlock.put(target.id(), holder);
                            if (oldChoices == null) break;
                            Kiwi.LOGGER.error("Duplicate place choices for block {}: {} and {}", new Object[]{target.id(), oldChoices, holder});
                        }
                    }
                }
            }
            return new Preparation(choices, byTemplate, byBlock);
        }

        public boolean attachChoicesA(class_2248 block, KBlockDefinition definition) {
            KHolder<PlaceChoices> choices = this.byTemplate.get(definition.template().template());
            PlaceChoices.setTo(block, choices);
            return choices != null;
        }

        public int attachChoicesB() {
            AtomicInteger counter = new AtomicInteger();
            this.byBlock.forEach((blockId, choices) -> {
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockId);
                if (block == class_2246.field_10124) {
                    Kiwi.LOGGER.error("Block %s not found for place choices %s".formatted(blockId, choices));
                    return;
                }
                PlaceChoices.setTo(block, choices);
                counter.incrementAndGet();
            });
            return counter.get();
        }
    }
}

